import { execGame } from "./game.js";
import { execScore } from "./score.js";
import { initDB, getDB } from "./db.js";

async function startGame() {
  /**@type {HTMLSelectElement} */
  const selector = document.getElementById("level-selector");
  const limitSeconds = selector.selectedOptions[0].value;
  console.log("GameStart limit = " + limitSeconds)
  await showScreen("game");
  let difficulty = "";
  switch(Number.parseInt(limitSeconds)){
    case 3:
      difficulty = "easy";
      break;
    case 2:
      difficulty = "normal";
      break;
    case 1:
      difficulty = "hard";
      break;
  }
  execGame(limitSeconds, difficulty);
}

async function showScores() {
  getDB().then(async results => {
    if (results.length > 0) {
      await showScreen("score");
      execScore(results);
    } else {
      alert("スコア記録がまだありません");
    }
  }).catch(err => {
    alert("スコア取得エラー");
    console.error("IndexedDBエラー:", err);
  });
}

function exitGame() {
  if(confirm("終了しますか？")){
    location.href = "../index.html";
  }
}

async function loadTemplate(name) {
  const res = await fetch(`./html/${name}.html`);
  const text = await res.text();
  const parser = new DOMParser();
  const doc = parser.parseFromString(text, 'text/html');
  const template = doc.querySelector('template');
  return template.content.cloneNode(true);
}

export async function showScreen(name) {
  const body = document.body;
  body.innerHTML = "";
  const content = await loadTemplate(name);
  body.appendChild(content);
  if(name === "title"){
    document.getElementById("gameBtn").onclick = startGame;
    document.getElementById("scoreBtn").onclick = showScores;
    document.getElementById("exitBtn").onclick = exitGame;
  }
}

initDB(()=>{});
// 初期起動時（タイトル画面表示）
showScreen("title");
// showScores();
